/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Attribute;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.supervised.attribute.MergeNominalValues;

public class MergeNominalValuesTest
extends AbstractFilterTest {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances.setClassIndex(1);
    }

    public MergeNominalValuesTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        MergeNominalValues f = new MergeNominalValues();
        return f;
    }

    public void testTypical() {
        Instances result = this.useFilter();
        MergeNominalValuesTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        MergeNominalValuesTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        Attribute mergedAtt = result.attribute(4);
        MergeNominalValuesTest.assertTrue("Attribute 5 has all values merged in result", mergedAtt.value(0).equals("a_or_b_or_c_or_d"));
    }

    public void testDifferentRange() {
        ((MergeNominalValues)this.m_Filter).setAttributeIndices("1,3");
        ((MergeNominalValues)this.m_Filter).setInvertSelection(true);
        Instances result = this.useFilter();
        MergeNominalValuesTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        MergeNominalValuesTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
    }

    public void testAttributeWithMissing() {
        ((MergeNominalValues)this.m_Filter).setAttributeIndices("5");
        Instances result = this.useFilter();
        MergeNominalValuesTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        MergeNominalValuesTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        int mergedIndex = -1;
        int i = 0;
        while (i < result.numInstances()) {
            if (this.m_Instances.instance(i).isMissing(4)) {
                MergeNominalValuesTest.assertTrue("Missing in input should give missing in result", result.instance(i).isMissing(4));
            }
            ++i;
        }
    }

    @Override
    public void testFilteredClassifier() {
        try {
            Instances data = this.getFilteredClassifierData();
            int i = 0;
            while (i < data.numAttributes()) {
                if (data.classIndex() != i && data.attribute(i).isNominal()) {
                    ((MergeNominalValues)this.m_FilteredClassifier.getFilter()).setAttributeIndices("" + (i + 1));
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            MergeNominalValuesTest.fail("Problem setting up test for FilteredClassifier: " + e.toString());
        }
        super.testFilteredClassifier();
    }

    public static Test suite() {
        return new TestSuite(MergeNominalValuesTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(MergeNominalValuesTest.suite());
    }
}

